ModeIconColors = {
	Easy		= color("#00C0ff"),
	Normal		= color("#00C0ff"),
	Hard		= color("#00C0ff"),
	Nonstop		= color("#ffff00"),
	Oni			= color("#ff8000"),
	Drill		= color("#ff0000"),
	Extended	= color("#ffff00"),
	Rave		= color("#64C000"),
	Endless		= color("#ff0000"),
}
GameColor = {
	PlayerColors = {
		PLAYER_1 = color("#ef406d"),
		PLAYER_2 = color("#0089cf"),
	},
	Difficulty = {
		--[[ These are for 'Custom' Difficulty Ranks. It can be very  useful
		in some cases, especially to apply new colors for stuff you
		couldn't before. (huh? -aj) ]]
		Beginner	= color("#93278f"),			-- light cyan
		Easy		= color("#7ac943"),			-- green
		Medium		= color("#fbb03b"),			-- yellow
		Hard		= color("#ff7bac"),			-- red
		Challenge	= color("#3fa9f5"),			-- light blue
		Edit		= color("#b3b3b3"),			-- gray
		Couple		= color("#ed0972"),			-- hot pink
		Routine		= color("#ff9a00"),			-- orange
		--[[ These are for courses, so let's slap them here in case someone
		wanted to use Difficulty in Course and Step regions. ]]
		Difficulty_Beginner	= color("#93278f"),		-- purple
		Difficulty_Easy		= color("#7ac943"),		-- green
		Difficulty_Medium	= color("#fbb03b"),		-- yellow
		Difficulty_Hard		= color("#ff7bac"),		-- red
		Difficulty_Challenge	= color("#3fa9f5"),	-- light blue
		Difficulty_Edit 	= color("#b3b3b3"),		-- gray
		Difficulty_Couple	= color("#ed0972"),				-- hot pink
		Difficulty_Routine	= color("#ff9a00")				-- orange
	},
	Stage = {
		Stage_1st	= color("#ff1493"),
		Stage_2nd	= color("#ff1493"),
		Stage_3rd	= color("#ff1493"),
		Stage_4th	= color("#ff1493"),
		Stage_5th	= color("#ff1493"),
		Stage_6th	= color("#ff1493"),
		Stage_Next	= color("#ff1493"),
		Stage_Final	= color("#ff00ff"),
		Stage_Extra1	= color("#ff0000"),
		Stage_Extra2	= color("#9932cc"),
		Stage_Nonstop	= color("#ff8000"),
		Stage_Oni	= color("#ff0000"),
		Stage_Endless	= color("#ff0000"),
		Stage_Event	= color("#FFFFFF"),
		Stage_Demo	= color("#FFFFFF"),
	},
	Judgment = {
		JudgmentLine_W1		= color("#bfeaff"),
		JudgmentLine_W2		= color("#fff568"),
		JudgmentLine_W3		= color("#a4ff00"),
		JudgmentLine_W4		= color("#34bfff"),
		JudgmentLine_W5		= color("#e44dff"),
		JudgmentLine_Held	= color("#ff8c00"),
		JudgmentLine_Miss	= color("#ff3c3c"),
		JudgmentLine_MaxCombo	= color("#ffc600")
	},
}

function D3Color(name)
	if getenv("D3MIXMode") then
		if name=="Text" then
			return color("0.11,0.47,0.92,1.0");
		elseif name=="Light" then
			return color("0.8,0.9,1.0,1.0");
		elseif name=="LDark" then
			return color("0.3,0.4,0.5,1.0");
		elseif name=="Dark" then
			return color("0.1,0.2,0.3,1.0");
		elseif name=="Red" then
			return color("0.1,0.3,1.0,1.0");
		end;
		return color("0.11,0.47,0.92,1.0");
	else
		if name=="Text" then
			return color("0.92,0.11,0.47,1.0");
		elseif name=="Light" then
			return color("1.0,0.8,0.9,1.0");
		elseif name=="LDark" then
			return color("0.5,0.3,0.4,1.0");
		elseif name=="Dark" then
			return color("0.3,0.1,0.2,1.0");
		elseif name=="Red" then
			return color("1.0,0.1,0.0,1.0");
		end;
		return color("0.92,0.11,0.47,1.0");
	end;
end;
function PlayerColor( pn )
	if getenv("D3MIXMode") then
		if pn == PLAYER_1 then return GameColor.PlayerColors["PLAYER_2"] end
		if pn == PLAYER_2 then return GameColor.PlayerColors["PLAYER_1"] end
	else
		if pn == PLAYER_1 then return GameColor.PlayerColors["PLAYER_1"] end
		if pn == PLAYER_2 then return GameColor.PlayerColors["PLAYER_2"] end
	end;
	return color("1,1,1,1")
end
function PlayerScoreColor( pn )
	if pn == PLAYER_1 then return GameColor.PlayerColors["PLAYER_1"] end
	if pn == PLAYER_2 then return GameColor.PlayerColors["PLAYER_2"] end
	return color("1,1,1,1")
end

GameColor.Difficulty["Crazy"] = GameColor.Difficulty["Hard"]
GameColor.Difficulty["Freestyle"] = GameColor.Difficulty["Easy"]
GameColor.Difficulty["Nightmare"] = GameColor.Difficulty["Challenge"]
GameColor.Difficulty["HalfDoubleEasy"] = GameColor.Difficulty["Easy"]
GameColor.Difficulty["HalfDoubleMedium"] = GameColor.Difficulty["Medium"]
GameColor.Difficulty["HalfDoubleHard"] = GameColor.Difficulty["Hard"]
GameColor.Difficulty["HalfDoubleExpert"] = GameColor.Difficulty["Expert"]

